/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class TableRecipeStorage {
    private final BaseItemStackHandler[] recipes = new BaseItemStackHandler[3];
    private final int slots;
    private int selected = -1;

    public TableRecipeStorage(int slots) {
        this.slots = slots;
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i] = new BaseItemStackHandler(slots);
        }
    }

    public int getSlots() {
        return this.slots;
    }

    public int getSelected() {
        return this.selected;
    }

    public void setSelected(int selected) {
        if (selected == this.selected || selected < -1 || selected > 2) {
            selected = -1;
        }
        this.selected = selected;
    }

    public BaseItemStackHandler getRecipe(int index) {
        if (index < 0 || index >= this.recipes.length) {
            return null;
        }
        return this.recipes[index];
    }

    public boolean hasRecipe(int index) {
        if (index < 0 || index >= this.recipes.length) {
            return false;
        }
        return !this.recipes[index].getStacks().stream().allMatch(ItemStack::m_41619_);
    }

    public void setRecipe(int index, BaseItemStackHandler inventory, ItemStack output) {
        BaseItemStackHandler recipe = new BaseItemStackHandler(this.slots);
        for (int i = 0; i < this.slots - 1; ++i) {
            recipe.setStackInSlot(i, inventory.getStackInSlot(i));
        }
        recipe.setStackInSlot(this.slots - 1, output);
        this.recipes[index] = recipe;
    }

    public void unsetRecipe(int index) {
        if (index < 0 || index >= this.recipes.length) {
            return;
        }
        this.recipes[index] = new BaseItemStackHandler(this.slots);
        if (index == this.selected) {
            this.selected = -1;
        }
    }

    public BaseItemStackHandler[] getRecipes() {
        return this.recipes;
    }

    public BaseItemStackHandler getSelectedRecipe() {
        if (this.selected < 0 || this.selected > this.recipes.length) {
            return null;
        }
        return this.recipes[this.selected];
    }

    public CompoundTag serializeNBT() {
        ListTag recipes = new ListTag();
        for (int i = 0; i < this.recipes.length; ++i) {
            recipes.add(i, (Tag)this.recipes[i].serializeNBT());
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Recipes", (Tag)recipes);
        tag.m_128405_("Selected", this.selected);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        ListTag recipes = tag.m_128437_("Recipes", 10);
        for (int i = 0; i < recipes.size(); ++i) {
            this.recipes[i].deserializeNBT(recipes.m_128728_(i));
        }
        this.selected = tag.m_128451_("Selected");
    }
}

